/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Pio.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    Standardized definitions of RX PIOs

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_PIO_H
#define __AP_PIO_H

#ifdef __cplusplus
extern "C" {
#endif
  
  
 /*
  **************************************************************************
  *   Size of one PIO Control Block a Task has to allocate memory for
  **************************************************************************
  */ 

  #define DRV_PIO_SIZE (84)

  /*
  ************************************************************
  *   Function Prototypes
  ************************************************************
  */
    
  RX_FATAL FAR    DrvPioInit            (const FAR void FAR*      pvCfg,
                                         UINT                     uNum); 

  RX_RESULT FAR   Drv_PioCreatePio      (RX_HANDLE                hPio,
                                         const RX_PIO_SET_T FAR*  ptCfg); 

  RX_RESULT FAR   Drv_PioIdentifyPio    (const STRING FAR*        pszIdn,
                                         UINT                     uInst,
                                         RX_HANDLE FAR*           phPio);

  RX_RESULT FAR   Drv_PioInitializePio  (RX_HANDLE                hPio);

  RX_RESULT FAR   Drv_PioSetOutputs     (RX_HANDLE                hPio,
                                         UINT                     uOutput);

  RX_RESULT FAR   Drv_PioClearOutputs   (RX_HANDLE                hPio,
                                         UINT                     uOutput);

  RX_RESULT FAR   Drv_PioGetInputs      (RX_HANDLE                hPio, 
                                         UINT FAR*                puInput);
  
#ifdef __cplusplus
}
#endif

#endif
